<?php
defined( 'ABSPATH' ) or die();

add_filter( 'marlab_customize_containers', 'marlab_customize_header_containers' );
add_filter( 'marlab_customize_controls', 'marlab_customize_header_controls' );
add_filter( 'marlab_customize_settings', 'marlab_customize_header_settings' );

function marlab_customize_header_containers( $containers ) {
	$containers['headerAndFooter'] = array(
		'type'        => 'panel',
		'title'       => _x( 'Header & Footer', 'customize', 'marlab' )
	);

	$containers['headerGeneral'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'General', 'customize', 'marlab' ),
		'parent'      => _x( 'Header Settings', 'customize', 'marlab' ),
		'heading'     => array(
			'title'       => esc_html__( 'Header Settings', 'marlab' ),
		)
	);
	$containers['headerTopbar'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Topbar Settings', 'customize', 'marlab' ),
		'parent'      => _x( 'Header Settings', 'customize', 'marlab' )
	);
	$containers['headerNavigator'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Navigation Bar', 'customize', 'marlab' ),
		'parent'      => _x( 'Header Settings', 'customize', 'marlab' ),
	);

	$containers['headerTitle'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Title Bar', 'customize', 'marlab' ),
		'parent'      => _x( 'Header Settings', 'customize', 'marlab' )
	);

	$containers['headerSticky'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'General Settings', 'customize', 'marlab' ),
		'heading'     => array(
			'title'       => esc_html__( 'Header Sticky Setting', 'marlab' ),
		)
	);
	$containers['headerStickyNav'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Navigation Bar', 'customize', 'marlab' )
	);

	return $containers;
}

function marlab_customize_header_controls( $controls ) {
	/**
	 * Header Styles
	 */
	$controls['header__style'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Header Styles', 'customize', 'marlab' ),
		'choices'     => array(
			'style1'  => _x( 'Style 1', 'customize', 'marlab' ),
			'style2'  => _x( 'Style 2', 'customize', 'marlab' ),
			'style3'  => _x( 'Style 3', 'customize', 'marlab' ),
			'style4'  => _x( 'Style 4', 'customize', 'marlab' )
		)
	);
	/**
	 * The logo profile
	 */
	$controls['header__logo'] = array(
		'type'        => 'dropdown',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Logo that will be shown', 'customize', 'marlab' ),
		'choices'     => array(
			'logoDefault' => _x( 'Logo Default', 'customize', 'marlab' ),
			'logoDark'    => _x( 'Logo Dark', 'customize', 'marlab' ),
			'logoLight'   => _x( 'Logo Light', 'customize', 'marlab' )
		)
	);
	$controls[ 'header__logoMargin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Logo Margin', 'marlab' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);

	/**
	 * Header Settings
	 */
	$controls['header__height'] = array(
		'type'        => 'textfield',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Header Height', 'customize', 'marlab' )
	);
	$controls['header__width'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => _x( '100% Header Full Width', 'customize', 'marlab' )
	);
	$controls['header__shadow'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Enable Shadow', 'marlab' ),
	);
	$controls['header__transparent'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Enable Header Transparent', 'marlab' ),
	);

	$controls['header__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Header Background', 'customize', 'marlab' )
	);
	$controls['header__background'] = array(
		'type'        => 'background',
		'section'     => 'headerGeneral'
	);

	$controls['header__info__text'] = array(
		'type'        => 'textareafield',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Site Info', 'customize', 'marlab' )
	);

	$controls['header__extras'] = array(
		'type'        => 'checkboxes',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Show Extra Items On The Header', 'marlab' ),
		'choices'     => array(
			'cart'      => _x( 'Shopping Cart', 'customize', 'marlab' ),
			'search'    => _x( 'Search Box', 'customize', 'marlab' )
		)
	);

	/**
	 * Topbar Settings
	 */
	$controls['header__topbar'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Enable Topbar', 'customize', 'marlab' )
	);

	// Topbar content
	$controls['header__topbar__text'] = array(
		'type'        => 'textareafield',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Topbar Content', 'customize', 'marlab' )
	);

	$controls['header__topbar__typoHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTopbar',
		'label'       => esc_html__( 'Topbar Font', 'marlab' ),
	);
	$controls['header__topbar__typography'] = array(
		'type'        => 'typography',
		'section'     => 'headerTopbar'
	);
	$controls['header__topbar__colors'] = array(
		'type'        => 'colors',
		'section'     => 'headerTopbar',
		'label'       => esc_html__( 'Topbar Link Colors', 'marlab' ),
		'choices'     => array(
			'menu'        => esc_html__( 'Link Color', 'marlab' ),
			'menu-hover'  => esc_html__( 'Hover Color', 'marlab' ),
			'menu-active' => esc_html__( 'Active Color', 'marlab' )
		)
	);

	$controls['header__topbar__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Topbar Background', 'customize', 'marlab' )
	);
	$controls['header__topbar__background'] = array(
		'type'        => 'background',
		'section'     => 'headerTopbar'
	);

	/**
	 * Navigation Bar Settings
	 */
	$controls['header__nav__typography'] = array(
		'type'        => 'typography',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Font', 'marlab' ),
	);
	$controls['header__nav__colors'] = array(
		'type'        => 'colors',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Colors', 'marlab' ),
		'choices'     => array(
			'menu'        => esc_html__( 'Menu Color', 'marlab' ),
			'menu-hover'  => esc_html__( 'Hover Color', 'marlab' ),
			'menu-active' => esc_html__( 'Active Color', 'marlab' )
		)
	);
	$controls[ 'header__nav__margin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Margin', 'marlab' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);
	$controls['header__nav__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Padding', 'marlab' ),
		'choices'     => array(
			'padding-top'    => esc_html__( 'Top', 'marlab' ),
			'padding-right'  => esc_html__( 'Right', 'marlab' ),
			'padding-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'padding-left'   => esc_html__( 'Left', 'marlab' )
		)
	);

	/**
	 * Sticky Header Settings
	 */
	$controls['header__sticky'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => _x( 'Enable Sticky Header', 'customize', 'marlab' ),
		'default'     => 'on'
	);
	$controls['header__sticky__style'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerSticky',
		'label'       => _x( 'Header Styles', 'customize', 'marlab' ),
		'choices'     => array(
			'style1'  => _x( 'Style 1', 'customize', 'marlab' ),
			'style2'  => _x( 'Style 2', 'customize', 'marlab' ),
			'style3'  => _x( 'Style 3', 'customize', 'marlab' ),
			'style4'  => _x( 'Style 4', 'customize', 'marlab' )
		)
	);
	$controls['header__sticky__logo'] = array(
		'type'        => 'dropdown',
		'section'     => 'headerSticky',
		'label'       => _x( 'Logo that will be shown', 'customize', 'marlab' ),
		'choices'     => array(
			'logoDefault' => _x( 'Logo Default', 'customize', 'marlab' ),
			'logoDark'    => _x( 'Logo Dark', 'customize', 'marlab' ),
			'logoLight'   => _x( 'Logo Light', 'customize', 'marlab' )
		)
	);
	$controls[ 'header__sticky__logoMargin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerSticky',
		'label'       => esc_html__( 'Logo Margin', 'marlab' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);

	/**
	 * Header Settings
	 */
	$controls['header__sticky__height'] = array(
		'type'        => 'textfield',
		'section'     => 'headerSticky',
		'label'       => _x( 'Header Sticky Height', 'customize', 'marlab' )
	);
	$controls['header__sticky__width'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => _x( '100% Full Width', 'customize', 'marlab' )
	);
	
	$controls['header__sticky__shadow'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => esc_html__( 'Enable Shadow', 'marlab' ),
	);

	$controls['header__sticky__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerSticky',
		'label'       => _x( 'Header Sticky Background', 'customize', 'marlab' )
	);
	$controls['header__sticky__background'] = array(
		'type'        => 'background',
		'section'     => 'headerSticky'
	);

	$controls['header__sticky__nav__typography'] = array(
		'type'        => 'typography',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Font', 'marlab' ),
	);
	$controls['header__sticky__nav__colors'] = array(
		'type'        => 'colors',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Colors', 'marlab' ),
		'choices'     => array(
			'menu'        => esc_html__( 'Menu Color', 'marlab' ),
			'menu-hover'  => esc_html__( 'Hover Color', 'marlab' ),
			'menu-active' => esc_html__( 'Active Color', 'marlab' )
		)
	);
	$controls[ 'header__sticky__nav__margin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Margin', 'marlab' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);
	$controls['header__sticky__nav__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Padding', 'marlab' ),
		'choices'     => array(
			'padding-top'    => esc_html__( 'Top', 'marlab' ),
			'padding-right'  => esc_html__( 'Right', 'marlab' ),
			'padding-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'padding-left'   => esc_html__( 'Left', 'marlab' )
		)
	);


	/**
	 * Title bar
	 */
	$controls['header__titlebar'] = array(
		'type'        => 'dropdown',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Displays', 'customize', 'marlab' ),
		'choices'     => array(
			'both'        => _x( 'Page Title and Breadcrumbs', 'customize', 'marlab' ),
			'title'       => _x( 'Page Title Only', 'customize', 'marlab' ),
			'breadcrumbs' => _x( 'Breadcrumbs Only', 'customize', 'marlab' ),
			'none'        => _x( 'None', 'customize', 'marlab' )
		)
	);
	$controls['header__titlebar__align'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Alignment', 'customize', 'marlab' ),
		'choices'     => array(
			'left'   => _x( 'Left', 'customize', 'marlab' ),
			'center' => _x( 'Center', 'customize', 'marlab' ),
			'right'  => _x( 'Right', 'customize', 'marlab' ),
			'inline' => _x( 'Inline', 'customize', 'marlab' )
		)
	);
	$controls['header__titlebar__height'] = array(
		'type'        => 'textfield',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Height', 'customize', 'marlab' )
	);
	$controls['header__titlebar__home'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => _x( 'Display On The Homepage', 'customize', 'marlab' )
	);
	$controls['header__titlebar__scrolldown'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Enable Scroll Down Button', 'marlab' ),
	);
	$controls['header__titlebar__background'] = array(
		'type'        => 'background',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Background', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls[ 'header__titlebar__margin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Title Bar Margin', 'marlab' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);
	$controls['header__titlebar__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Title Bar Padding', 'marlab' ),
		'choices'     => array(
			'padding-top'    => esc_html__( 'Top', 'marlab' ),
			'padding-right'  => esc_html__( 'Right', 'marlab' ),
			'padding-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'padding-left'   => esc_html__( 'Left', 'marlab' )
		)
	);
	$controls['header__titlebar__backgroundFeatured'] = array(
		'type'        => 'checkboxes',
		'section'     => 'headerTitle',
		'label'       => _x( 'Use Featured Image As Background in', 'customize', 'marlab' ),
		'choices'     => 'marlab_customize_post_types_options'
	);

	$controls['header__titlebar__titleHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTitle',
		'label'       => _x( 'Page Title Font', 'customize', 'marlab' )
	);
	$controls['header__titlebar__titleFont'] = array(
		'type'        => 'typography',
		'section'     => 'headerTitle'
	);

	$controls['header__titlebar__breadcrumbColors'] = array(
		'type'        => 'colors',
		'section'     => 'headerTitle',
		'label'       => _x( 'Breadcrumbs Link Color', 'customize', 'marlab' ),
		'choices'     => array(
			'link' => _x( 'Link Color', 'customize', 'marlab' ),
			'linkHover' => _x( 'Hover Color', 'customize', 'marlab' )
		)
	);


	/**
	 * Sticky Header Settings
	 */
	$controls['header__widgets'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'header__widgets',
		'label'       => _x( 'Enable Sticky Header', 'customize', 'marlab' ),
		'description' => _x( 'Turn ON to enable the header widgets area', 'customize', 'marlab' ),
		'default'     => 'on'
	);

	return $controls;
}



function marlab_customize_header_settings( $settings ) {
	$border_default = array( 'size' => '0px', 'style' => 'none', 'color' => '#000000' );
	$settings = array_merge( $settings, array(
		'header__style'  => array( 'default' => 'style1' ),
		'header__logo'       => array( 'default' => 'logoDefault' ),
		'header__logoMargin' => array( 'default' => array() ),

		'header__width'      => array( 'default' => 'on' ),
		'header__height'     => array( 'default' => '' ),
		'header__background' => array( 'default' => array() ),
		'header__shadow'     => array( 'default' => 'off' ),
		'header__transparent' => array( 'default' => 'off' ),
		'header__extras'     => array( 'default' => array() ),

		'header__topbar'             => array( 'default' => 'off' ),
		'header__topbar__text'       => array( 'default' => 'Content here' ),
		'header__topbar__icons'      => array( 'default' => '' ),
		'header__topbar__background' => array( 'default' => array() ),
		'header__topbar__typography' => array( 'default' => array() ),
		'header__topbar__colors'     => array( 'default' => array() ),

		'header__nav__typography' => array( 'default' => array() ),
		'header__nav__colors'     => array( 'default' => array() ),
		'header__nav__margin'     => array( 'default' => array() ),
		'header__nav__padding' => array( 'default' => array() ),
		'header__nav__background' => array( 'default' => array() ),

		'header__sticky'             => array( 'default' => 'off' ),
		'header__sticky__style'      => array( 'default' => 'style1' ),
		'header__sticky__logo'       => array( 'default' => 'logoDefault' ),
		'header__sticky__logoMargin' => array( 'default' => array() ),

		'header__sticky__width'      => array( 'default' => 'on' ),
		'header__sticky__height'     => array( 'default' => '' ),
		'header__sticky__background' => array( 'default' => array() ),
		'header__sticky__shadow'     => array( 'default' => 'off' ),
		'header__sticky__nav__typography' => array( 'default' => array() ),
		'header__sticky__nav__colors'     => array( 'default' => array() ),
		'header__sticky__nav__margin'     => array( 'default' => array() ),
		'header__sticky__nav__padding'    => array( 'default' => array() ),

		'header__titlebar'         => array( 'default' => 'both' ),
		'header__titlebar__home'   => array( 'default' => 'on' ),
		'header__titlebar__align'  => array( 'default' => 'left' ),
		'header__titlebar__height' => array( 'default' => '' ),
		'header__titlebar__margin' => array( 'default' => array() ),
		'header__titlebar__padding' => array( 'default' => array() ),
		'header__titlebar__scrolldown' => array( 'default' => 'on' ),
		'header__titlebar__background'         => array( 'default' => array() ),
		'header__titlebar__backgroundFeatured' => array( 'default' => array() ),
		'header__titlebar__titleFont'          => array( 'default' => array() ),
		'header__titlebar__breadcrumbColors'   => array( 'default' => array() ),
	) );

	return $settings;
}
