<?php
defined( 'ABSPATH' ) or die();


/**
 * Radio buttons control
 */
class Marlab_Options_RadioOnOff extends Marlab_Options_RadioButtons
{
	public function __construct( $id, $args = array() ) {
		parent::__construct( $id, $args );

		$this->choices = array(
			'on'  => _x( 'On', 'options', 'marlab' ),
			'off' => _x( 'Off', 'options', 'marlab' )
		);
	}


	public function render_content() {
		?>

			<div class="options-control-inputs options-control-onoff">
				<radio-buttons v-bind:value="data" v-bind:options="choices" v-on:change="triggerChange"></radio-buttons>
			</div>

		<?php
	}
}
