<?php
defined( 'ABSPATH' ) or die();


$layout    = marlab_option( 'header__titlebar' );
$alignment = marlab_option( 'header__titlebar__align' );

$current_post = get_queried_object();

if ($current_post instanceof WP_Post) {
	/**
	 * Override layout and alignment settings for the specific entry
	 */
	$_layout = get_field( 'titlebarLayout', $current_post->ID );
	$_alignment = get_field( 'titlebarAlign', $current_post->ID );
}

if ( isset( $_layout ) && $_layout != 'default' ) {
	$layout = $_layout;
}

if ( isset( $_alignment ) && $_alignment != 'default' ) {
	$alignment = $_alignment;
}

if ( ( is_front_page() && marlab_option( 'header__titlebar__home' ) == 'off' ) || $layout == 'none' ) {
	return;
}

$classes = array(
	"content-header",
	"content-header-{$alignment}"
);

if ( is_singular() ) {
	$featured_background_types = (array) marlab_option( 'header__titlebar__backgroundFeatured' );
	$current_post_type         = marlab_current_post_type();


	if ( in_array( $current_post_type, $featured_background_types ) && has_post_thumbnail( $current_post->ID ) ) {
		$classes[] = 'content-header-featured';
	}
}

?>

<div class="<?php echo esc_attr( join( ' ', $classes ) ) ?>">
	<div class="content-header-inner wrap">
		<?php if ( function_exists( 'bcn_display' ) && in_array( $layout, array( 'both', 'breadcrumbs' ) ) ): ?>
		<div class="breadcrumbs">
			<div class="breadcrumbs-inner">
				<?php bcn_display() ?>
			</div>
		</div>
	<?php endif ?>

		<div class="page-title-wrap">
			<?php if ( in_array( $layout, array( 'both', 'title' ) ) ): ?>
				<div class="page-title">
					<?php marlab_header_page_title() ?>
				</div>

				<?php if ( is_single( $post ) && $post->post_type == 'post' ): ?>
					<?php if ( marlab_option( 'blog__single__postMeta' ) == 'on' ): ?>
						<div><?php get_template_part( 'tmpl/post/content-meta' ) ?></div>
				<?php endif ?>

				<?php wp_reset_postdata() ?>

			<?php endif ?>
		<?php endif ?>
	    </div>

		<?php if ( marlab_option( 'header__titlebar__scrolldown' ) == 'on' ): ?>
		<div  class="down-arrow">
			<a href="javascript:;">
				<span><?php esc_html_e( 'Scroll Down', 'marlab' ) ?></span>
			</a>
		</div>
	<?php endif ?>
	</div>

	<?php if ( is_single( $post ) && $post->post_type == 'post' ): ?>
		<?php if ( marlab_option( 'blog__single__postNav' ) == 'on' ): ?>
			<?php get_template_part( 'tmpl/post/content-navigator' ) ?>
		<?php endif ?>
	<?php endif ?>

	<?php if ( is_single( $post ) && $post->post_type == 'nproject' ): ?>
		<?php if ( marlab_option( 'project__pagination' ) == 'on' ): ?>
			<?php get_template_part( 'tmpl/post/content-navigator' ) ?>
		<?php endif ?>
	<?php endif ?>
</div>
