<?php

/**
 * visapass customizer
 *
 * @package visapass
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Added Panels & Sections
 */
function visapass_customizer_panels_sections($wp_customize)
{

    //Add panel
    $wp_customize->add_panel('visapass_customizer', [
        'priority' => 10,
        'title'    => esc_html__('Visapass Customizer', 'visapass'),
    ]);

    /**
     * Customizer Section
     */
    $wp_customize->add_section('header_top_setting', [
        'title'       => esc_html__('Header Topbar Setting', 'visapass'),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('sectionheader_logo', [
        'title'       => esc_html__('Header Setting', 'visapass'),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('header_social', [
        'title'       => esc_html__('Social Profile', 'visapass'),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('header_side_setting', [
        'title'       => esc_html__('Side Info', 'visapass'),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('breadcrumb_setting', [
        'title'       => esc_html__('Breadcrumb Setting', 'visapass'),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('blog_setting', [
        'title'       => esc_html__('Blog Setting', 'visapass'),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('footer_setting', [
        'title'       => esc_html__('Footer Settings', 'visapass'),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('footer_social', [
        'title'       => esc_html__('Footer Social', 'visapass'),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('color_setting', [
        'title'       => esc_html__('Color Setting', 'visapass'),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('404_page', [
        'title'       => esc_html__('404 Page', 'visapass'),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('typo_setting', [
        'title'       => esc_html__('Typography Setting', 'visapass'),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ]);

    $wp_customize->add_section('header_topbar_style', array(
        'title'       => esc_html__('Header Topbar Style', 'visapass'),
        'description' => '',
        'priority'    => 20,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ));

    $wp_customize->add_section('header_panel_style', array(
        'title'       => esc_html__('Header Panel Style', 'visapass'),
        'description' => '',
        'priority'    => 21,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ));

    $wp_customize->add_section('nav_menu_style', array(
        'title'       => esc_html__('Desktop Menu Style', 'visapass'),
        'description' => '',
        'priority'    => 22,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ));

    $wp_customize->add_section('mobile_menu_style', array(
        'title'       => esc_html__('Mobile Menu Style', 'visapass'),
        'description' => '',
        'priority'    => 23,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ));

    $wp_customize->add_section('footer_style', array(
        'title'       => esc_html__('Footer Style', 'visapass'),
        'description' => '',
        'priority'    => 24,
        'capability'  => 'edit_theme_options',
        'panel'       => 'visapass_customizer',
    ));
}

add_action('customize_register', 'visapass_customizer_panels_sections');

function header_top_fields($fields)
{

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_topbar_switch',
        'label'    => esc_html__('Topbar Swicher', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_preloader',
        'label'    => esc_html__('Preloader On/Off', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_backtotop',
        'label'    => esc_html__('Back To Top On/Off', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_header_right',
        'label'    => esc_html__('Header Right On/Off', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_showheader_search',
        'label'    => esc_html__('Search On/Off', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    // header-topbar location
    $fields[] = [
        'type'            => 'text',
        'settings'        => 'visapass_address',
        'label'           => esc_html__('Address', 'visapass'),
        'section'         => 'header_top_setting',
        'default'         => esc_html__('Our Location', 'visapass'),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'visapass_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    $fields[] = [
        'type'     => 'link',
        'settings' => 'visapass_address_link',
        'label'    => esc_html__('Address URL', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'visapass_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    // header-topbar office opening time
    $fields[] = [
        'type'            => 'text',
        'settings'        => 'visapass_time_text',
        'label'           => esc_html__('Opening Time Text', 'visapass'),
        'section'         => 'header_top_setting',
        'default'         => esc_html__('Opening Time', 'visapass'),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'visapass_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'visapass_time',
        'label'           => esc_html__('Opening Time', 'visapass'),
        'section'         => 'header_top_setting',
        'default'         => esc_html__('8:30 AM - 9:30 PM', 'visapass'),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'visapass_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];


    // Apply button
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_apply_btn',
        'label'    => esc_html__('Apply Now Button Text', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => esc_html__('Apply Now', 'visapass'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'visapass_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'link',
        'settings' => 'visapass_apply_link',
        'label'    => esc_html__('Apply Now Button URL', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'visapass_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    // Menu right
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_mcontact_text',
        'label'    => esc_html__('Menu Right Call Text', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => esc_html__('Contact Us', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_mcontact_cell',
        'label'    => esc_html__('Menu Right Call Number', 'visapass'),
        'section'  => 'header_top_setting',
        'default'  => esc_html__('(555) 5802 3059', 'visapass'),
        'priority' => 10,
    ];

    return $fields;
}
add_filter('kirki/fields', 'header_top_fields');

/*
Header Social
 */
function header_social_fields($fields)
{
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_topbar_fb_url',
        'label'    => esc_html__('Facebook Url', 'visapass'),
        'section'  => 'header_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_topbar_twitter_url',
        'label'    => esc_html__('Twitter Url', 'visapass'),
        'section'  => 'header_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_topbar_linkedin_url',
        'label'    => esc_html__('Linkedin Url', 'visapass'),
        'section'  => 'header_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_topbar_instagram_url',
        'label'    => esc_html__('Instagram Url', 'visapass'),
        'section'  => 'header_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_topbar_youtube_url',
        'label'    => esc_html__('Youtube Url', 'visapass'),
        'section'  => 'header_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_4',
        'label'    => esc_html__('Icon Style', 'visapass'),
        'section'  => 'header_social',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'sp_icon_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'header_social',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.top_social.offset_social a'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'sp_icon_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'header_social',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.top_social.offset_social a:hover'
            ],
        ]
    ];

    return $fields;
}
add_filter('kirki/fields', 'header_social_fields');

/*
Header Settings
 */
function headerheader_fields($fields)
{

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__('Header Logo', 'visapass'),
        'description' => esc_html__('Upload Your Logo.', 'visapass'),
        'section'     => 'sectionheader_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'seconday_logo',
        'label'       => esc_html__('Header Logo', 'visapass'),
        'description' => esc_html__('Header White Logo', 'visapass'),
        'section'     => 'sectionheader_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'slider',
        'settings'    => 'visapass_logo_size',
        'label'       => esc_html__('Header Logo Size', 'visapass'),
        'description' => esc_html__('Header Logo Size', 'visapass'),
        'section'     => 'sectionheader_logo',
        'default' => '150px',
        'choices'     => [
            'min'  => 100,
            'max'  => 400,
            'step' => 4,
        ],
    ];

    return $fields;
}
add_filter('kirki/fields', 'headerheader_fields');

/*
Header Side Info
 */
function header_side_fields($fields)
{
    // side info settings
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_side_hide',
        'label'    => esc_html__('Side Info On/Off', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    // contact
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_contact_info',
        'label'    => esc_html__('Contact Info', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => esc_html__('Contact Info', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_extra_mail',
        'label'    => esc_html__('E-mail Address', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => esc_html__('support@gmail.com ', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_extra_phone',
        'label'    => esc_html__('Phone Number', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => esc_html__('+1 878 298 023', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_extra_address',
        'label'    => esc_html__('Office Address', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => esc_html__('Street 222, South Africa', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'link',
        'settings' => 'visapass_extra_address_link',
        'label'    => esc_html__('Office Address Url', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'header_side_setting',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_5',
        'label'    => esc_html__('Contact Info Style', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'si_title_color',
        'label'    => esc_html__('Title Color', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.contact-list h4'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'si_icon_color',
        'label'    => esc_html__('Icon Color', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.contact-list.mobile_contact a i'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'si_text_color',
        'label'    => esc_html__('Text Color', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.contact-list.mobile_contact a'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'si_text_hcolor',
        'label'    => esc_html__('Text Hover Color', 'visapass'),
        'section'  => 'header_side_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.contact-list.mobile_contact a:hover'
            ],
        ]
    ];

    return $fields;
}
add_filter('kirki/fields', 'header_side_fields');

/*
header_page_title_fields
 */
function header_page_title_fields($fields)
{
    // Breadcrumb Setting

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_bg_img',
        'label'       => esc_html__('Breadcrumb Background Image', 'visapass'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/page-title/page-title.jpg',
    ];
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'visapass_breadcrumb_bg_color',
        'label'       => __('Breadcrumb BG Color', 'visapass'),
        'section'     => 'breadcrumb_setting',
        'default'     => '',
        'priority'    => 10,
        'output'    => [
            [
                'element'  => '.page-title__area',
                'property' => 'background-color'
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'title_tag',
        'label'       => esc_html__('Choose Title Tag', 'visapass'),
        'section'     => 'breadcrumb_setting',
        'default'     => 'h1',
        'placeholder' => esc_html__('Select an option...', 'visapass'),
        'priority'    => 10,
        'choices'     => [
            'h1' => esc_html__('H1', 'visapass'),
            'h2' => esc_html__('H2', 'visapass'),
            'h3' => esc_html__('H3', 'visapass'),
            'h4' => esc_html__('H4', 'visapass'),
            'h5' => esc_html__('H5', 'visapass'),
            'h6' => esc_html__('H6', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'breadcrumb_title',
        'label'    => esc_html__('Title Color', 'visapass'),
        'section'  => 'breadcrumb_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.page__title-wrapper .page-title'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'breadcrumb_nav',
        'label'    => esc_html__('Nav Color', 'visapass'),
        'section'  => 'breadcrumb_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.breadcrumbs li a, .breadcrumbs li span'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'breadcrumb_sperator',
        'label'    => esc_html__('Separator Color', 'visapass'),
        'section'  => 'breadcrumb_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.breadcrumbs ul li:not(:last-child)::after'
            ],
        ],
    ];

    return $fields;
}
add_filter('kirki/fields', 'header_page_title_fields');

/*
Header Blog fileds
 */
function header_blog_fields($fields)
{
    // Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_blog_btn_switch',
        'label'    => esc_html__('Blog BTN On/Off', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_blog_btn',
        'label'    => esc_html__('Blog Button text', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => esc_html__('Read More', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_blog_btn_rtl',
        'label'    => esc_html__('Blog Button text rtl', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => esc_html__('Read More', 'visapass'),
        'priority' => 10,
    ];


    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_1',
        'label'    => esc_html__('Blog Meta Style', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_meta_icon_color',
        'label'    => esc_html__('Icon Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.ablog__meta4 ul li a i'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_meta_text_color',
        'label'    => esc_html__('Text Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.ablog__meta4 ul li a'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_meta_text_hcolor',
        'label'    => esc_html__('Text Hover Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.ablog__meta ul li a:hover'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_2',
        'label'    => esc_html__('Blog Content Style', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_title_color',
        'label'    => esc_html__('Title Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.ablog__text--title4'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_title_hcolor',
        'label'    => esc_html__('Title Hover Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.ablog__text--title4:hover'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_text_color',
        'label'    => esc_html__('Text Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.post-text p'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_content_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'    => [
            [
                'element'  => '.blog-post-items .blog',
                'property' => 'background'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'dimensions',
        'settings' => 'breadcrumg_padding',
        'label'    => esc_html__('Padding (Ex: 25px)', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => [
            'padding-top'   => '',
            'padding-right'   => '',
            'padding-bottom'  => '',
            'padding-left'  => '',
        ],
        'choices'     => [
            'labels' => [
                'padding-top' => esc_html__('Padding Top', 'visapass'),
                'padding-right' => esc_html__('Padding Right', 'visapass'),
                'padding-bottom' => esc_html__('Padding Bottom', 'visapass'),
                'padding-left' => esc_html__('Padding Left', 'visapass'),
            ],
        ],
        'output'    => [
            [
                'element'  => '.blog-post-items .ablog__text'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_3',
        'label'    => esc_html__('Button Style', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_btn_text_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => 'a.v_blog_btn'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_btn_text_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => 'a.v_blog_btn:hover'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_btn_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => 'a.v_blog_btn',
                'property' => 'background'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'blog_btn_bg_hcolor',
        'label'    => esc_html__('Background Hover Color', 'visapass'),
        'section'  => 'blog_setting',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => 'a.v_blog_btn:hover',
                'property' => 'background'
            ],
        ]
    ];

    return $fields;
}
add_filter('kirki/fields', 'header_blog_fields');

/*
Footer
 */
function header_footer_fields($fields)
{
    // Footer Setting
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__('Choose Footer Style', 'visapass'),
        'section'     => 'footer_setting',
        'default'     => 'footer-style-1',
        'placeholder' => esc_html__('Select an option...', 'visapass'),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1' => esc_html__('Footer Style 1', 'visapass'),
            'footer-style-2' => esc_html__('Footer Style 2', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__('Widget Number', 'visapass'),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__('Select an option...', 'visapass'),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            '5' => esc_html__('Widget Number 5', 'visapass'),
            '4' => esc_html__('Widget Number 4', 'visapass'),
            '3' => esc_html__('Widget Number 3', 'visapass'),
            '2' => esc_html__('Widget Number 2', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'visapass_footer_bg',
        'label'       => esc_html__('Footer Background Image.', 'visapass'),
        'description' => esc_html__('Footer Background Image.', 'visapass'),
        'section'     => 'footer_setting',
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'visapass_footer_bg_color',
        'label'       => __('Footer BG Color', 'visapass'),
        'description' => esc_html__('This is a Footer bg color control.', 'visapass'),
        'section'     => 'footer_setting',
        'default'     => '#222429',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'visapass_Footer_1_menu_hover_color',
        'label'       => __('Footer 1 Menu Hover Color', 'visapass'),
        'description' => esc_html__('This is Footer 1 Menu Hover color control.', 'visapass'),
        'section'     => 'footer_setting',
        'default'     => '#7127ea',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_style_2_switch',
        'label'    => esc_html__('Footer Style 2 On/Off', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];



    // copyight cell number 
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_footer_right',
        'label'    => esc_html__('Footer Right On/Off', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => '2',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];


    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_footer_left',
        'label'    => esc_html__('Footer Left On/Off', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'visapass_footer_newslatters',
        'label'    => esc_html__('Footer Newsletters On/Off', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'visapass'),
            'off' => esc_html__('Disable', 'visapass'),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'visapass_footer_logo',
        'label'       => esc_html__('Footer Logo', 'visapass'),
        'description' => esc_html__('Footer Logo', 'visapass'),
        'section'     => 'footer_setting',
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_footer_newsletter_text',
        'label'    => esc_html__('Newsletters Text', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('Get More Update Join Our Newsletters', 'visapass'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_copyright_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_copyright',
        'label'    => esc_html__('Copy Right', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('Copyright &copy; 2022 BDevs. All Rights Reserved', 'visapass'),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_copyright_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_terms_condition_text',
        'label'    => esc_html__('Terms & Condition Text', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'link',
        'settings' => 'visapass_terms_condition_link',
        'label'    => esc_html__('Terms & Condition URL', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_privacy_policy_text',
        'label'    => esc_html__('Privacy Policy Text', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'link',
        'settings' => 'visapass_privacy_policy_url',
        'label'    => esc_html__('Privacy Policy URL', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    // footer copyright right
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_copyright_cell_text',
        'label'    => esc_html__('Footer Right Cell Text', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('Call - Or - SMS', 'visapass'),
        'priority' => 10,

    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_copyright_cell_number',
        'label'    => esc_html__('Footer Right Cell Number', 'visapass'),
        'section'  => 'footer_setting',
        'default'  => esc_html__('+1 878 298 023', 'visapass'),
        'priority' => 10,
    ];



    return $fields;
}
add_filter('kirki/fields', 'header_footer_fields');

/*
 Footer Social
 */
function footer_social_fields($fields)
{
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_footer_fb_url',
        'label'    => esc_html__('Facebook Url', 'visapass'),
        'section'  => 'footer_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_footer_twitter_url',
        'label'    => esc_html__('Twitter Url', 'visapass'),
        'section'  => 'footer_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_footer_linkedin_url',
        'label'    => esc_html__('Linkedin Url', 'visapass'),
        'section'  => 'footer_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_footer_instagram_url',
        'label'    => esc_html__('Instagram Url', 'visapass'),
        'section'  => 'footer_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_footer_youtube_url',
        'label'    => esc_html__('Youtube Url', 'visapass'),
        'section'  => 'footer_social',
        'default'  => esc_html__('#', 'visapass'),
        'priority' => 10,
    ];


    return $fields;
}
add_filter('kirki/fields', 'footer_social_fields');


// color
function visapass_color_fields($fields)
{
    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'visapass_color_option',
        'label'       => __('Theme Color', 'visapass'),
        'description' => esc_html__('This is a Theme color control.', 'visapass'),
        'section'     => 'color_setting',
        'default'     => '#E48216',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'visapass_primary_color',
        'label'       => __('visapass Primary Color', 'visapass'),
        'description' => esc_html__('This is visapass primary color control.', 'visapass'),
        'section'     => 'color_setting',
        'default'     => '#1A1C20',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'visapass_secondary_color',
        'label'       => __('visapass Secondary Color', 'visapass'),
        'description' => esc_html__('This is visapass secondary color control.', 'visapass'),
        'section'     => 'color_setting',
        'default'     => '#D16C07',
        'priority'    => 10,
    ];
    return $fields;
}
add_filter('kirki/fields', 'visapass_color_fields');

// 404
function visapass_404_fields($fields)
{
    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_error_404_text',
        'label'    => esc_html__('400 Text', 'visapass'),
        'section'  => '404_page',
        'default'  => esc_html__('404', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_error_title',
        'label'    => esc_html__('Not Found Title', 'visapass'),
        'section'  => '404_page',
        'default'  => esc_html__('Page not found', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'visapass_error_desc',
        'label'    => esc_html__('404 Description Text', 'visapass'),
        'section'  => '404_page',
        'default'  => esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted', 'visapass'),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'visapass_error_link_text',
        'label'    => esc_html__('404 Link Text', 'visapass'),
        'section'  => '404_page',
        'default'  => esc_html__('Back To Home', 'visapass'),
        'priority' => 10,
    ];
    return $fields;
}
add_filter('kirki/fields', 'visapass_404_fields');

/**
 * Added Fields
 */
function visapass_typo_fields($fields)
{
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__('Body Font', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'body',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__('Heading h1 Fonts', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h1',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h2_setting',
        'label'       => esc_html__('Heading h2 Fonts', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h2',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h3_setting',
        'label'       => esc_html__('Heading h3 Fonts', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h3',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h4_setting',
        'label'       => esc_html__('Heading h4 Fonts', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h4',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h5_setting',
        'label'       => esc_html__('Heading h5 Fonts', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h5',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h6_setting',
        'label'       => esc_html__('Heading h6 Fonts', 'visapass'),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h6',
            ],
        ],
    ];
    return $fields;
}
add_filter('kirki/fields', 'visapass_typo_fields');

// Header topbar style
function visapass_header_topbar_style($fields)
{

    $fields[] = [
        'type'     => 'color',
        'settings' => 'top_time_color',
        'label'    => esc_html__('Time Color', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.header-top-left ul li span'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'top_text_hcolor',
        'label'    => esc_html__('Text Color', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.header-top-left ul li, .header-location ul li a, .header-location ul li i'
            ],
        ]
    ];


    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_300',
        'label'    => esc_html__('Fill Button Style', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fbtn_text_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.top-button a'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fbtn_text_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.top-button a:is(:hover,:focus)'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fbtn_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.top-button a',
                'property' => 'background'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fbtn_bg_hcolor',
        'label'    => esc_html__('Background Hover Color', 'visapass'),
        'section'  => 'header_topbar_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.top-button a:is(:hover,:focus)',
                'property' => 'background'
            ],
        ]
    ];

    return $fields;
}
add_filter('kirki/fields', 'visapass_header_topbar_style');

// Header Panel Style
function visapass_header_panel_style($fields)
{

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_40',
        'label'    => esc_html__('Header Style', 'visapass'),
        'section'  => 'header_panel_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'header_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'header_panel_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.header-top',
                'property' => 'background'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'header_bg_scolor',
        'label'    => esc_html__('Background Sticky Color', 'visapass'),
        'section'  => 'header_panel_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.header-menu.header-sticky.sticky-menu, .mobile-header.header-sticky.sticky-menu',
                'property' => 'background'
            ],
        ]
    ];

    return $fields;
}
add_filter('kirki/fields', 'visapass_header_panel_style');

// Navigation menu style
function visapass_nav_menu_style($fields)
{
    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_60',
        'label'    => esc_html__('Menu Style', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'number',
        'settings'    => 'menu_text_size',
        'label'       => esc_html__('Font Size', 'visapass'),
        'section'     => 'nav_menu_style',
        'default'     => '',
        'output'   => [
            [
                'element'  => '.main-menu ul li a',
                'property' => 'font-size',
                'units'    => 'px'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'menu_text_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.main-menu ul li a, .main-menu nav > ul > li.menu-item-has-children > a::after'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'menu_text_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.main-menu ul li a:is(:hover,:focus), .main-menu nav > ul > li.menu-item-has-children > a:hover::after'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'dimensions',
        'settings' => 'menu_padding',
        'label'    => esc_html__('Padding (ex:10px)', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => [
            'padding-top'   => '',
            'padding-bottom'  => '',
        ],
        'choices'     => [
            'labels' => [
                'padding-top' => esc_html__('Padding Top', 'visapass'),
                'padding-bottom' => esc_html__('Padding Bottom', 'visapass'),
            ],
        ],
        'output'    => [
            [
                'element'  => '.main-menu ul li a'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'dimensions',
        'settings' => 'menu_margin',
        'label'    => esc_html__('Margin (ex:10px)', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => [
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels' => [
                'margin-left' => esc_html__('Margin Laft', 'visapass'),
                'margin-right' => esc_html__('Margin Right', 'visapass'),
            ],
        ],
        'output'    => [
            [
                'element'  => '.main-menu ul li'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_80',
        'label'    => esc_html__('Dropdown Menu Style', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'number',
        'settings'    => 'dropdown_menu_size',
        'label'       => esc_html__('Width', 'visapass'),
        'section'     => 'nav_menu_style',
        'default'     => '',
        'output'   => [
            [
                'element'  => '.main-menu ul li .sub-menu',
                'property' => 'width',
                'units'    => 'px'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'dropdown_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.main-menu ul li .sub-menu',
                'property' => 'background'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'dropdown_border_color',
        'label'    => esc_html__('Border Color', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.main-menu ul li .sub-menu',
                'property' => 'border-color'
            ],
        ]
    ];

    $fields[] = [
        'type'        => 'number',
        'settings'    => 'dropdown_text_size',
        'label'       => esc_html__('Font Size', 'visapass'),
        'section'     => 'nav_menu_style',
        'default'     => '',
        'output'   => [
            [
                'element'  => '.main-menu ul li .sub-menu li a',
                'property' => 'font-size',
                'units'    => 'px'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'dropdown_text_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.main-menu ul li .submenu li > a'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'dropdown_text_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'nav_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.main-menu ul li .submenu li:hover > a'
            ],
        ]
    ];

    return $fields;
}

add_filter('kirki/fields', 'visapass_nav_menu_style');

// Mobile menu style
function visapass_mobile_menu_style($fields)
{

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_90',
        'label'    => esc_html__('Panel Style', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'number',
        'settings'    => 'panel_width_size',
        'label'       => esc_html__('Width', 'visapass'),
        'section'     => 'mobile_menu_style',
        'default'     => '',
        'output'   => [
            [
                'element'  => '.side-info',
                'property' => 'width',
                'units'    => 'px'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'panel_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.side-info',
                'property' => 'background',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_100',
        'label'    => esc_html__('Menu Close button Style', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'number',
        'settings'    => 'close_text_size',
        'label'       => esc_html__('Font Size', 'visapass'),
        'section'     => 'mobile_menu_style',
        'default'     => '',
        'output'   => [
            [
                'element'  => 'button.side-info-close',
                'property' => 'font-size',
                'units'    => 'px'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'close_text_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => 'button.side-info-close'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_111',
        'label'    => esc_html__('Menu Item Style', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'        => 'number',
        'settings'    => 'mmenu_text_size',
        'label'       => esc_html__('Font Size', 'visapass'),
        'section'     => 'mobile_menu_style',
        'default'     => '',
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a',
                'property' => 'font-size',
                'units'    => 'px'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_text_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_text_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a:is(:hover, :focus)'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_border_color',
        'label'    => esc_html__('Border Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a',
                'property' => 'border-color'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_12',
        'label'    => esc_html__('Menu Plus Icon Style', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_plus_color',
        'label'    => esc_html__('Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a.mean-expand',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_plus_hcolor',
        'label'    => esc_html__('Hover Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a.mean-expand:hover',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_plus_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a.mean-expand',
                'property' => 'background'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_plus_bg_hcolor',
        'label'    => esc_html__('Background Hover Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a.mean-expand:hover',
                'property' => 'background'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_plus_border_color',
        'label'    => esc_html__('Border Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a.mean-expand',
                'property' => 'border-color'
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'mmenu_plus_border_hcolor',
        'label'    => esc_html__('Border Hover Color', 'visapass'),
        'section'  => 'mobile_menu_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.mean-container .mean-nav ul li a.mean-expand:hover',
                'property' => 'border-color'
            ],
        ]
    ];

    return $fields;
}
add_filter('kirki/fields', 'visapass_mobile_menu_style');

// Footer Style
function visapass_footer_style($fields)
{

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_18',
        'label'    => esc_html__('Footer One Style', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_title_color',
        'label'    => esc_html__('Title Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg2 .footer__widget-title',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_text_color',
        'label'    => esc_html__('Text Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg2 .footer__widget .textwidget p, .footer-bg2 .footer__widget ul li a, .footer-bg2 .footer__widget ul li span, .footer-bg2 .footer__widget ul li:last-child span',
            ],
        ]
    ];


    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_text_hcolor',
        'label'    => esc_html__('Link Hover Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg2 .footer__widget ul li a:hover',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'footer_bg_color',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer__area.footer-bg2',
                'property' => 'background',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'footer_bottom_text_color',
        'label'    => esc_html__('Bottom Text Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-coptright .footer__text p, .footer-copyright__wrapper__call-number span, .footer-copyright__wrapper__call-number h5',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'footer_bottom_bg_color',
        'label'    => esc_html__('Bottom Background Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-coptright.theme-bg',
                'property' => 'background',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'dimensions',
        'settings' => 'footer_padding',
        'label'    => esc_html__('Padding (Ex: 100px)', 'visapass'),
        'section'  => 'footer_style',
        'default'  => [
            'padding-top'   => '',
            'padding-bottom'  => '',
        ],
        'choices'     => [
            'labels' => [
                'padding-top' => esc_html__('Padding Top', 'visapass'),
                'padding-bottom' => esc_html__('Padding Bottom', 'visapass'),
            ],
        ],
        'output'    => [
            [
                'element'  => '.footer-bg2 .footer-top'
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'custom',
        'settings' => 'separator_19',
        'label'    => esc_html__('Footer Two Style', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '<hr>',
        'priority' => 10,
    ];


    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_title_color2',
        'label'    => esc_html__('Title Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg .footer-widget__title, .footer-bg .footer-about-1__title, .footer-bg .subscribe-top .copyright-title',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_text_color2',
        'label'    => esc_html__('Text Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg .footer-widget.widget_text p, .footer-bg .footer-widget li a, .footer-bg .footer-widget_menu-link-info li a',
            ],
        ]
    ];


    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_text_hcolor2',
        'label'    => esc_html__('Link Hover Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg .footer-widget li a:hover, .footer-bg .footer-widget_menu-link-info li a:hover',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'fwidget_icon_hcolor2',
        'label'    => esc_html__('Icon Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-bg .footer-widget_menu-link-info li a i',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'footer_bg_color2',
        'label'    => esc_html__('Background Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-area.footer-bg',
                'property' => 'background',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'footer_copyright_color2',
        'label'    => esc_html__('Copyright Text Color', 'visapass'),
        'section'  => 'footer_style',
        'default'  => '',
        'priority' => 10,
        'output'   => [
            [
                'element'  => '.footer-copyright-area .copyright-botom p, .copyright-botom-right ul li a',
            ],
        ]
    ];

    $fields[] = [
        'type'     => 'dimensions',
        'settings' => 'footer_padding2',
        'label'    => esc_html__('Padding (Ex: 100px)', 'visapass'),
        'section'  => 'footer_style',
        'default'  => [
            'padding-top'   => '',
            'padding-bottom'  => '',
        ],
        'choices'     => [
            'labels' => [
                'padding-top' => esc_html__('Padding Top', 'visapass'),
                'padding-bottom' => esc_html__('Padding Bottom', 'visapass'),
            ],
        ],
        'output'    => [
            [
                'element'  => '.footer-style-2 .footer__top'
            ],
        ],
    ];

    return $fields;
}
add_filter('kirki/fields', 'visapass_footer_style');

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function VISAPASS_THEME_option($name)
{
    $value = '';
    if (class_exists('visapass')) {
        $value = Kirki::get_option(visapass_get_theme(), $name);
    }

    return apply_filters('VISAPASS_THEME_option', $value, $name);
}

/**
 * Get config ID
 *
 * @return string
 */
function visapass_get_theme()
{
    return 'visapass';
}
